#include <stdbool.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <vector>

#include <pb.h>
#include <pb_decode.h>
#include <pb_encode.h>
#include <utils.hpp>

#include "_resetprop.hpp"

using namespace std;

/* ***********************************************************************
 * Auto generated header and constant definitions compiled from
 * android/platform/system/core/master/init/persistent_properties.proto
 * using Nanopb's protoc
 * Nanopb: https://github.com/nanopb/nanopb
 * ***********************************************************************/

/* Automatically generated nanopb header */
/* Generated by nanopb-0.3.9.1 at Sun Apr 22 14:36:22 2018. */

/* @@protoc_insertion_point(includes) */
#if PB_PROTO_HEADER_VERSION != 30
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Struct definitions */
typedef struct _PersistentProperties {
    pb_callback_t properties;
/* @@protoc_insertion_point(struct:PersistentProperties) */
} PersistentProperties;

typedef struct _PersistentProperties_PersistentPropertyRecord {
    pb_callback_t name;
    bool has_value;
    char value[92];
/* @@protoc_insertion_point(struct:PersistentProperties_PersistentPropertyRecord) */
} PersistentProperties_PersistentPropertyRecord;

/* Default values for struct fields */

/* Initializer values for message structs */
#define PersistentProperties_init_default        {{{NULL}, NULL}}
#define PersistentProperties_PersistentPropertyRecord_init_default {{{NULL}, NULL}, false, ""}
#define PersistentProperties_init_zero           {{{NULL}, NULL}}
#define PersistentProperties_PersistentPropertyRecord_init_zero {{{NULL}, NULL}, false, ""}

/* Field tags (for use in manual encoding/decoding) */
#define PersistentProperties_properties_tag      1
#define PersistentProperties_PersistentPropertyRecord_name_tag 1
#define PersistentProperties_PersistentPropertyRecord_value_tag 2

/* Automatically generated nanopb constant definitions */
/* Generated by nanopb-0.3.9.1 at Sun Apr 22 14:36:22 2018. */

/* Struct field encoding specification for nanopb */
const pb_field_t PersistentProperties_PersistentPropertyRecord_fields[3] = {
		PB_FIELD(  1, STRING  , OPTIONAL, CALLBACK, FIRST, PersistentProperties_PersistentPropertyRecord, name, name, 0),
		PB_FIELD(  2, STRING  , OPTIONAL, STATIC  , OTHER, PersistentProperties_PersistentPropertyRecord, value, name, 0),
		PB_LAST_FIELD
};

const pb_field_t PersistentProperties_fields[2] = {
		PB_FIELD(  1, MESSAGE , REPEATED, CALLBACK, FIRST, PersistentProperties, properties, properties, &PersistentProperties_PersistentPropertyRecord_fields),
		PB_LAST_FIELD
};

/* Maximum encoded size of messages (where known) */
/* PersistentProperties_size depends on runtime parameters */
/* PersistentProperties_PersistentPropertyRecord_size depends on runtime parameters */

/* Message IDs (where set with "msgid" option) */
#ifdef PB_MSGID

#define PROPS_MESSAGES \

#endif
/* @@protoc_insertion_point(eof) */


/* ***************************
 * End of auto generated code
 * ***************************/

bool use_pb = false;

#ifdef APPLET_STUB_MAIN
struct {
	void push_back(...){};
} allocs;
void persist_cleanup(){}
#else
static thread_local vector<void *> allocs;
void persist_cleanup() {
	std::for_each(allocs.begin(), allocs.end(), [](auto p){ free(p); });
	allocs.clear();
}
#endif

static bool name_decode(pb_istream_t *stream, const pb_field_t *field, void **arg) {
	auto name = (pb_byte_t *) malloc(stream->bytes_left + 1);
	allocs.push_back(name);  /* Record all mallocs to cleanup */
	name[stream->bytes_left] = '\0';
	if (!pb_read(stream, name, stream->bytes_left))
		return false;
	*arg = name;
	return true;
}

static bool name_encode(pb_ostream_t *stream, const pb_field_t *field, void * const *arg) {
	return pb_encode_tag_for_field(stream, field) &&
		   pb_encode_string(stream, (const pb_byte_t *) *arg, strlen((const char *) *arg));
}

static bool prop_decode(pb_istream_t *stream, const pb_field_t *field, void **arg) {
	PersistentProperties_PersistentPropertyRecord prop = {};
	prop.name.funcs.decode = name_decode;
	if (!pb_decode(stream, PersistentProperties_PersistentPropertyRecord_fields, &prop))
		return false;
	reinterpret_cast<prop_cb*>(*arg)->exec((const char *) prop.name.arg, prop.value);
	return true;
}

static bool prop_encode(pb_ostream_t *stream, const pb_field_t *field, void * const *arg) {
	PersistentProperties_PersistentPropertyRecord prop = {};
	prop.name.funcs.encode = name_encode;
	prop.has_value = true;
	auto &list = *(prop_list *) *arg;
	for (auto &p : list) {
		if (!pb_encode_tag_for_field(stream, field))
			return false;
		prop.name.arg = (void *) p.first.data();
		strcpy(prop.value, p.second.data());
		if (!pb_encode_submessage(stream, PersistentProperties_PersistentPropertyRecord_fields, &prop))
			return false;
	}
	return true;
}

static bool write_callback(pb_ostream_t *stream, const uint8_t *buf, size_t count) {
	int fd = (intptr_t)stream->state;
	return xwrite(fd, buf, count) == count;
}

static pb_ostream_t create_ostream(const char *filename) {
	int fd = creat(filename, 0644);
	pb_ostream_t o = {
		.callback = write_callback,
		.state = (void*)(intptr_t)fd,
		.max_size = SIZE_MAX,
		.bytes_written = 0,
	};
	return o;
}

static void pb_getprop(prop_cb *prop_cb) {
	LOGD("resetprop: decode with protobuf [" PERSISTENT_PROPERTY_DIR "/persistent_properties]\n");
	PersistentProperties props = {};
	props.properties.funcs.decode = prop_decode;
	props.properties.arg = prop_cb;
	pb_byte_t *buf;
	size_t size;
	mmap_ro(PERSISTENT_PROPERTY_DIR "/persistent_properties", buf, size);
	pb_istream_t stream = pb_istream_from_buffer(buf, size);
	pb_decode(&stream, PersistentProperties_fields, &props);
	munmap(buf, size);
}

static bool file_getprop(const char *name, char *value) {
	char path[PATH_MAX];
	snprintf(path, sizeof(path), PERSISTENT_PROPERTY_DIR "/%s", name);
	int fd = open(path, O_RDONLY | O_CLOEXEC);
	if (fd < 0)
		return false;
	LOGD("resetprop: read prop from [%s]\n", path);
	value[read(fd, value, PROP_VALUE_MAX)] = '\0';  // Null terminate the read value
	close(fd);
	return value[0] != '\0';
}

void persist_getprops(prop_cb *prop_cb) {
	if (use_pb) {
		pb_getprop(prop_cb);
	} else {
		DIR *dir = opendir(PERSISTENT_PROPERTY_DIR);
		struct dirent *entry;
		while ((entry = readdir(dir))) {
			if (strcmp(entry->d_name, ".") == 0 || strcmp(entry->d_name, "..") == 0 )
				continue;
			char value[PROP_VALUE_MAX];
			if (file_getprop(entry->d_name, value))
				prop_cb->exec(entry->d_name, value);
		}
	}
}

string persist_getprop(const char *name) {
	if (use_pb) {
		run_finally f([]{ persist_cleanup(); });
		struct {
			const char *name;
			char value[PROP_VALUE_MAX];
		} prop;
		prop.name = name;
		prop.value[0] = '\0';
		auto reader = make_prop_cb(prop, [](auto name, auto value, auto prop) {
			if (strcmp(name, prop.name) == 0)
				strcpy(prop.value, value);
		});
		pb_getprop(&reader);
		if (prop.value[0])
			return prop.value;
	} else {
		// Try to read from file
		char value[PROP_VALUE_MAX];
		if (file_getprop(name, value))
			return value;
	}
	return string();
}

bool persist_deleteprop(const char *name) {
	if (use_pb) {
		run_finally f([]{ persist_cleanup(); });
		prop_list list;
		prop_collector collector(list);
		persist_getprops(&collector);

		for (auto it = list.begin(); it != list.end(); ++it) {
			if (it->first == name) {
				list.erase(it);
				// Dump the props back
				PersistentProperties props = PersistentProperties_init_zero;
				pb_ostream_t ostream = create_ostream(PERSISTENT_PROPERTY_DIR
						"/persistent_properties.tmp");
				props.properties.funcs.encode = prop_encode;
				props.properties.arg = &list;
				LOGD("resetprop: encode with protobuf [" PERSISTENT_PROPERTY_DIR
							 "/persistent_properties.tmp]\n");
				if (!pb_encode(&ostream, PersistentProperties_fields, &props))
					return false;
				clone_attr(PERSISTENT_PROPERTY_DIR "/persistent_properties",
						   PERSISTENT_PROPERTY_DIR "/persistent_properties.tmp");
				rename(PERSISTENT_PROPERTY_DIR "/persistent_properties.tmp",
					   PERSISTENT_PROPERTY_DIR "/persistent_properties");
				return true;
			}
		}
		return false;
	} else {
		char path[PATH_MAX];
		snprintf(path, sizeof(path), PERSISTENT_PROPERTY_DIR "/%s", name);
		if (unlink(path) == 0) {
			LOGD("resetprop: unlink [%s]\n", path);
			return true;
		}
	}
	return false;
}
